/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.postprocessing;

import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.FlowValue;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.postprocessing.FlowPostProcessor;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.postprocessing.MethodCallType;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.util.Bytecode;

public class CallTaggingPostProcessor
implements FlowPostProcessor {
    private final Type currentType;
    private final boolean isStatic;

    public CallTaggingPostProcessor(ClassNode classNode, MethodNode methodNode) {
        this.currentType = Type.getObjectType((String)classNode.name);
        this.isStatic = Bytecode.isStatic((MethodNode)methodNode);
    }

    @Override
    public void process(FlowValue node2, FlowPostProcessor.OutputSink sink) {
        MethodCallType type = this.getType(node2);
        if (type == null) {
            return;
        }
        node2.decorate("methodCallType", type);
        if (type == MethodCallType.SUPER) {
            sink.markAsSynthetic(node2.getInput(0));
            node2.removeParent(0);
        }
    }

    private MethodCallType getType(FlowValue node2) {
        if (!(node2.getInsn() instanceof MethodInsnNode)) {
            return null;
        }
        MethodInsnNode call = (MethodInsnNode)node2.getInsn();
        switch (call.getOpcode()) {
            case 182: 
            case 185: {
                return MethodCallType.NORMAL;
            }
            case 184: {
                return MethodCallType.STATIC;
            }
            case 183: {
                if (call.name.equals("<init>")) {
                    return null;
                }
                if (call.owner.equals(this.currentType.getInternalName())) {
                    return MethodCallType.NORMAL;
                }
                if (!this.isLoadThis(node2.getInput(0))) break;
                return MethodCallType.SUPER;
            }
        }
        return null;
    }

    private boolean isLoadThis(FlowValue node2) {
        if (this.isStatic || node2.isComplex() || node2.getInsn().getOpcode() != 25) {
            return false;
        }
        VarInsnNode load = (VarInsnNode)node2.getInsn();
        return load.var == 0;
    }
}

